<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreArticoliDalBlog extends VisualizzatoreComponente {
        private $impostazioni;
        private $datiBlog;
        private $gestoreTraduzioni;
        private $linguaCorrente;
        
        function __construct($db) {
            parent::__construct($db);
            $this->impostazioni       = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
            $this->impostazioniLingue = recuperaImpostazioniLingue(parent::getDb());
            $this->datiBlog           = parent::getDb()->leggiSingolaRiga("geec_blog",1);
        }
         
        function generaContenutoSezione($dati) {
            $datiArticoliDalBlog = parent::getDb()->leggiSingolaRiga("geec_articoliDalBlog",$dati["idElemento"]);
            
            echo"<div class=\"{$datiArticoliDalBlog['spazioOccupato']}\">"
                . "<div class=\"row\">";
                if($datiArticoliDalBlog['mostraTitoloComponente']=="si") {
                    echo"<div class=\"col-12\">
                        <h3 class=\"text-center separatore-inferiore\"> {$datiArticoliDalBlog['nome']} </h3>"
                    ."</div>";
                }
                if($datiArticoliDalBlog["categoria"]==-1) {
                    $this->stampaArticoliCategorieIndicate($datiArticoliDalBlog);
                }
                else {
                    $this->stampaArticoliClassico($datiArticoliDalBlog);
                }
            echo"</div>";
            $this->stampaPulsante($datiArticoliDalBlog);
            echo"</div>";
        }

        /*
         * questo metodo viene usato se $datiArticoliDalBlog["categoria"] == -1, ovvero l'utente ha scelto
         * di creare il 
         */
        function stampaArticoliCategorieIndicate($datiArticoliDalBlog) {
            $dataOggi = date("Y-m-d H:i");
            
            if($datiArticoliDalBlog["categorieIndicate"]=="") {
                parent::messaggioDiErrore("Nessuna categoria selezionata");
            }
            else {
                $categorieIndicate = explode(",",$datiArticoliDalBlog["categorieIndicate"]);
                foreach($categorieIndicate as $categoria) {

                    $queryArticoli = "SELECT * FROM geecB_contenuti 
                        WHERE (categoria=$categoria AND categoria != {$datiArticoliDalBlog["escludiCategoria"]}) OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre=$categoria AND categoria != {$datiArticoliDalBlog["escludiCategoria"]} )
                        AND tipo LIKE 'articolo' 
                        AND stato LIKE 'pubblicato' 
                        AND dataPubblicazione <= '$dataOggi' 
                        AND linguaContenuto LIKE '%{$datiArticoliDalBlog["lingua"]}%' 
                        ORDER BY dataPubblicazione DESC LIMIT 1";

                    $risArticoli = parent::getDb()->eseguiQueryLettura($queryArticoli);
                    $articolo = $risArticoli->fetch_assoc();

                    $arrayCategorie = array();
                    if($articolo["categoria"]>0) {
                        $datiCategoriaPrincipale = parent::getDb()->leggiSingolaRiga("geec_categorie",$articolo["categoria"]);
                        $arrayCategorie[$datiCategoriaPrincipale["nome"]] = GeneratoreUrl::creaUrlCategoria($datiCategoriaPrincipale, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                    }
                    $queryCategorieArticoli="SELECT c.* FROM geec_associazioneCategorieContenuti AS ac JOIN geec_categorie AS c "
                                    . "ON ac.idCategoria = c.id "
                                    . "WHERE ac.idContenuto = {$articolo["id"]}";
                    $risCategorie = $this->getDb()->eseguiQueryLettura($queryCategorieArticoli);
                    while($categoria = $risCategorie->fetch_assoc()) {
                        $arrayCategorie[$categoria["nome"]] = GeneratoreUrl::creaUrlCategoria($categoria, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                    }

                    $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);

                    if($datiArticoliDalBlog["mostraImmagini"]=="si") {
                        StampaContenuti::articoliAffiancati($this->gestoreTraduzioni,$articolo, $this->datiBlog["aspettoImmagineInEvidenzaArticolo"], $linkArticolo, $arrayCategorie,$datiArticoliDalBlog["dimensioneDivSingoloArticolo"],$datiArticoliDalBlog["mostraTesto"]);
                    }
                    else {
                        StampaContenuti::visualizzazioneSenzaImmagine($this->gestoreTraduzioni,$articolo, $linkArticolo,$datiArticoliDalBlog["dimensioneDivSingoloArticolo"],$datiArticoliDalBlog["mostraTesto"]);
                    }
                }
            }
            
        }
        
        function stampaArticoliClassico($datiArticoliDalBlog) {
            $dataOggi = date("Y-m-d H:i");
            if($datiArticoliDalBlog["categoria"]!=0) {
                $queryArticoli = "SELECT * FROM geecB_contenuti 
                    WHERE ((categoria={$datiArticoliDalBlog["categoria"]} AND categoria != {$datiArticoliDalBlog["escludiCategoria"]}) OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre={$datiArticoliDalBlog["categoria"]} AND categoria != {$datiArticoliDalBlog["escludiCategoria"]} ))
                    AND tipo LIKE 'articolo' 
                    AND stato LIKE 'pubblicato' 
                    AND dataPubblicazione <= '$dataOggi' 
                    AND linguaContenuto LIKE '%{$datiArticoliDalBlog["lingua"]}%' 
                    ORDER BY dataPubblicazione DESC LIMIT {$datiArticoliDalBlog["numeroArticoli"]}";
            }
            else {
                $queryArticoli = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'articolo' AND stato LIKE 'pubblicato' AND categoria != {$datiArticoliDalBlog["escludiCategoria"]} AND dataPubblicazione <= '$dataOggi' AND linguaContenuto LIKE '%{$datiArticoliDalBlog["lingua"]}%' ORDER BY dataPubblicazione DESC LIMIT {$datiArticoliDalBlog["numeroArticoli"]}";
            }

            $risArticoli = parent::getDb()->eseguiQueryLettura($queryArticoli);
            while($articolo = $risArticoli->fetch_assoc()) {
               
                $arrayCategorie = array();
                
                if($articolo["categoria"]!=0) {
                    $categoria = $this->getDb()->leggiSingolaRiga("geec_categorie",$articolo["categoria"]);
                    $arrayCategorie[$categoria["nome"]] = GeneratoreUrl::creaUrlCategoria($categoria, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                }
                
                $queryArticoli="SELECT c.* FROM geec_associazioneCategorieContenuti AS ac JOIN geec_categorie AS c "
                                . "WHERE ac.idContenuto = {$articolo["id"]}";
                $risCategorie = $this->getDb()->eseguiQueryLettura($queryArticoli);
                while($categoria = $risCategorie->fetch_assoc()) {
                    $arrayCategorie[$categoria["nome"]] = GeneratoreUrl::creaUrlCategoria($categoria, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                }
                
                $linkArticolo = GeneratoreUrl::creaUrlContenuto($articolo,$this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                
                if($datiArticoliDalBlog["mostraImmagini"]=="si") {
                    StampaContenuti::articoliAffiancati($this->gestoreTraduzioni,$articolo, $this->datiBlog["aspettoImmagineInEvidenzaArticolo"], $linkArticolo, $arrayCategorie,$datiArticoliDalBlog["dimensioneDivSingoloArticolo"]." articoloAffiancato",$datiArticoliDalBlog["mostraTesto"]);
                }
                else {
                    StampaContenuti::visualizzazioneSenzaImmagine($this->gestoreTraduzioni,$articolo, $linkArticolo,$datiArticoliDalBlog["dimensioneDivSingoloArticolo"],$datiArticoliDalBlog["mostraTesto"]);
                }
            }
        }
        
        function stampaPulsante($datiArticoliDalBlog) {
            if($datiArticoliDalBlog["etichettaPulsanteALtriArticoli"]!="") {
                $linguaLetteraMaiuscola = ($datiArticoliDalBlog["lingua"]=="") ? ucfirst($this->impostazioni["linguaSito"]) : ucfirst($datiArticoliDalBlog["lingua"]);
                $paginaBlog = parent::getDb()->leggiSingolaRiga("geecB_contenuti",$this->impostazioniLingue["paginaBlog$linguaLetteraMaiuscola"]);
                $linkBlog   = GeneratoreUrl::creaUrlContenuto($paginaBlog, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                echo"<div class=\"text-center mx-auto\">
                        <a href=\"$linkBlog\" class=\"btn btn-primary sharp leggi-tutto\">{$datiArticoliDalBlog["etichettaPulsanteALtriArticoli"]}</a>
                    </div>";
            }
        }
        
        // getter & setter
        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }

        public function getLinguaCorrente() {
            return $this->linguaCorrente;
        }

        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }

        public function setLinguaCorrente($linguaCorrente): void {
            $this->linguaCorrente = $linguaCorrente;
        }
    }